import { u as useRuntimeConfig, p as pageCache, c as defineEventHandler, n as getRequestHeaders, f as readBody, o as rebuildCache, q as flushHome } from '../../_/nitro.mjs';
import { g as global, m as modules, p as pages, f as footer, h as header } from '../../_/settings.mjs';
import crypto from 'crypto';
import QuickLRU from 'quick-lru';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const setSettings = async (host) => {
  var _a, _b, _c, _d, _e, _f;
  const config = useRuntimeConfig();
  const client = host;
  try {
    const res = await $fetch(config.private.apiBase, {
      method: "POST",
      headers: {
        "host": client,
        "X-Fe-Route": client
      },
      body: {
        query: `{
                  guaqi{
                    utils {
                    settings(client: "${client}")
                  }
                }
              }`
      }
    });
    if (!((_c = (_b = (_a = res.data) == null ? void 0 : _a.guaqi) == null ? void 0 : _b.utils) == null ? void 0 : _c.settings)) {
      return null;
    }
    let settings = null;
    let rawSettingsStr = null;
    const defaultSettings = {
      header,
      footer,
      pages,
      modules,
      global
    };
    if (!((_f = (_e = (_d = res.data) == null ? void 0 : _d.guaqi) == null ? void 0 : _e.utils) == null ? void 0 : _f.settings)) {
      settings = {
        page_settings: {
          desktop: defaultSettings,
          mobile: defaultSettings,
          tablet: defaultSettings
        }
      };
    } else {
      rawSettingsStr = res.data.guaqi.utils.settings;
      settings = JSON.parse(rawSettingsStr);
      if (!settings.page_settings) {
        settings.page_settings = {
          desktop: defaultSettings,
          mobile: defaultSettings,
          tablet: defaultSettings
        };
      }
    }
    await pageCache.set("gq_page_settings", settings, null, client);
    return settings;
  } catch (err) {
    console.error("API request error:", err);
    return null;
  }
  return null;
};

const usedNonces = new QuickLRU({
  maxSize: 1e3
  // 最多缓存 10000 个 nonce
});
const nonceExpiryTime = 300;
function isNonceUsed(nonce) {
  const expiry = usedNonces.get(nonce);
  if (!expiry) {
    return false;
  }
  if (Date.now() > expiry) {
    usedNonces.delete(nonce);
    return false;
  }
  return true;
}
const flushCache = defineEventHandler(async (event) => {
  const config = useRuntimeConfig();
  const headers = getRequestHeaders(event);
  const signature = headers["signature"];
  const timestamp = headers["timestamp"];
  const nonce = headers["nonce"];
  const apiSecret = config.private.apiSecret;
  if (!signature || !timestamp || !nonce || !apiSecret)
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  const currentTime = Math.floor(Date.now() / 1e3);
  const requestTime = parseInt(timestamp, 10);
  if (Math.abs(currentTime - requestTime) > nonceExpiryTime) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Timestamp out of window" })
    };
  }
  if (isNonceUsed(nonce)) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Nonce has already been used" })
    };
  }
  const expectedSignature = crypto.createHmac("sha256", apiSecret).update(timestamp + nonce).digest("hex");
  if (signature !== expectedSignature) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  }
  usedNonces.set(nonce, Date.now() + nonceExpiryTime * 1e3);
  const body = await readBody(event);
  const client = body.client.replace(/https?:\/\//, "").replace(/\/$/, "");
  if (!client) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Client is required" })
    };
  }
  if (body.msg === "flushCache") {
    if (body.keys) {
      console.log(body.keys, "keys");
      await rebuildCache(body.keys, client);
    } else {
      try {
        await pageCache.clear(client);
        await setSettings(client);
        await flushHome(client, 500);
      } catch (error) {
        console.error("Error saving settings to redis:", error);
      }
    }
    return {
      statusCode: 200,
      body: JSON.stringify({ message: "Cache has been flushed" })
    };
  }
  return {
    statusCode: 400,
    body: JSON.stringify({ error: "Invalid request" })
  };
});

export { flushCache as default };
