import { c as defineEventHandler, u as useRuntimeConfig, n as getRequestHeaders, f as readBody } from '../../_/nitro.mjs';
import crypto from 'crypto';
import QuickLRU from 'quick-lru';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const usedNonces = new QuickLRU({
  maxSize: 1e3
  // 最多缓存 1000 个 nonce
});
const nonceExpiryTime = 300;
function isNonceUsed(nonce) {
  const expiry = usedNonces.get(nonce);
  if (!expiry) {
    return false;
  }
  if (Date.now() > expiry) {
    usedNonces.delete(nonce);
    return false;
  }
  return true;
}
const getVersion = defineEventHandler(async (event) => {
  const config = useRuntimeConfig();
  const headers = getRequestHeaders(event);
  const signature = headers["signature"];
  const timestamp = headers["timestamp"];
  const nonce = headers["nonce"];
  const apiSecret = config.private.apiSecret;
  if (!signature || !timestamp || !nonce || !apiSecret)
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  const currentTime = Math.floor(Date.now() / 1e3);
  const requestTime = parseInt(timestamp, 10);
  if (Math.abs(currentTime - requestTime) > nonceExpiryTime) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Timestamp out of window" })
    };
  }
  if (isNonceUsed(nonce)) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Nonce has already been used" })
    };
  }
  const expectedSignature = crypto.createHmac("sha256", apiSecret).update(timestamp + nonce).digest("hex");
  if (signature !== expectedSignature) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  }
  usedNonces.set(nonce, Date.now() + nonceExpiryTime * 1e3);
  const body = await readBody(event);
  if (body.msg === "getVersion") {
    return {
      statusCode: 200,
      body: JSON.stringify({
        version: config.private.gqVersion,
        published_at: config.private.publishedAt,
        port: config.private.port
      })
    };
  }
  return {
    statusCode: 400,
    body: JSON.stringify({ error: "Invalid request" })
  };
});

export { getVersion as default };
