import { c as defineEventHandler, u as useRuntimeConfig, f as readBody, g as getCookie, w as wpClient, p as pageCache } from '../../_/nitro.mjs';
import { h as htmlToBlocks } from '../../_/htmltoblocks.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';
import 'cheerio';
import 'quick-lru';

const page = defineEventHandler(async (event) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l;
  let rawGoData = null;
  let pageData = null;
  let res = null;
  try {
    const config = useRuntimeConfig();
    const body = await readBody(event);
    if (!body.path) {
      return {
        statusCode: 403,
        messages: ["path is required"]
      };
    }
    const device = body.device;
    const host = body.host || event.context.host;
    event.context.host = host;
    let key = body.path == "/" ? "/index" : body.path;
    key = device + key;
    
       if (!body.loginData && !body.args?.type) {
      const cacheData = await pageCache.get(key,host);

      if (cacheData) {
        return cacheData;
      }
    }
    
    let lang = getCookie(event, "i18n_redirected");
    if (!lang) {
      lang = body.lang;
    }
    let currency = getCookie(event, "currency");
    if (!currency) {
      currency = body.currency;
    }
    if (!lang) {
      const path = body.path.split("/")[1];
      const langs = config.private.locales.split(",");
      const cleanLangs = langs.map((lang2) => lang2.split("|")[0]);
      const defaultLang = config.private.defaultLocale;
      if (cleanLangs.includes(path)) {
        lang = path;
      } else {
        lang = defaultLang;
      }
    }
    const ip = event.context.ip;
    let opt = {
      method: "POST",
      headers: {
        "host": host,
        "X-Fe-Route": host,
        "X-Fe-Ua-Type": device,
        "X-Fe-Lang": lang,
        "X-Fe-Currency": currency,
        "X-Fe-Ip": ip
      },
      body: {
        query: `{guaqi{go(path:"${body.path}",args:"""${JSON.stringify(body.args)}""")}}`
      },
      timeout: 3e4,
      // 添加 30 秒超时
      retry: 0
      // 禁用自动重试
    };
    if (body.loginData || ((_a = body.args) == null ? void 0 : _a.type) == "preview") {
      let authorizationHeader = (_b = event.context.authToken) != null ? _b : null;
      if (authorizationHeader && !((_c = body.data) == null ? void 0 : _c.serverUrl)) {
        Object.assign(opt.headers, {
          authorization: authorizationHeader
        });
      }
    }
    body.path = body.path.split("?")[0];
    try {
      res = await wpClient(
        config.private.apiBase + `?query={guaqi{go(path:"${body.path}",args:"""${JSON.stringify(
          body.args
        )}""")}}`,
        opt
      );
    } catch (fetchError) {
      const errorMessage = fetchError.message || "Request failed";
      console.error("Page API request failed:", errorMessage);
      throw fetchError;
    }
    if (!res.errors && ((_e = (_d = res == null ? void 0 : res.data) == null ? void 0 : _d.guaqi) == null ? void 0 : _e.go)) {
      try {
        rawGoData = res.data.guaqi.go;
        pageData = JSON.parse(rawGoData);
        if (pageData.statusCode == 404) {
          return { statusCode: 404, message: ["Not Found"] };
        }
        if (pageData.statusCode == 301) {
          return { statusCode: 301, redirectUrl: pageData.redirectUrl };
        }
        if (pageData.errors || !pageData) {
          const msg = pageData.errors[0].message.replace(
            /https?:\/\/[^\s]+/g,
            ""
          );
          return {
            statusCode: 403,
            messages: [msg]
          };
        }
        if (pageData.module) {
          Object.keys(pageData.module).forEach((key2) => {
            var _a2, _b2, _c2;
            if ((((_a2 = pageData.module[key2]) == null ? void 0 : _a2.type) == "content" || ((_b2 = pageData.module[key2]) == null ? void 0 : _b2.gqPostType) == "community_answer") && ((_c2 = pageData.module[key2]) == null ? void 0 : _c2.content)) {
              const originalContent = pageData.module[key2].content;
              pageData.module[key2].content = htmlToBlocks(originalContent);
            }
          });
        }
        if (!body.loginData && pageData && !pageData.errors && !(((_f = body.args) == null ? void 0 : _f.type) == "preview") && ((_g = pageData.cache) == null ? void 0 : _g.path)) {
          pageCache.set(key, pageData, null, host).catch((err) => {
            console.error("Cache set failed:", err);
          });
        }
        return pageData;
      } finally {
        if (rawGoData && ((_h = res == null ? void 0 : res.data) == null ? void 0 : _h.guaqi)) {
          delete res.data.guaqi.go;
        }
        rawGoData = null;
      }
    } else {
      if (!((_i = res == null ? void 0 : res.errors) == null ? void 0 : _i[0])) {
        return null;
      }
      if (true) {
        return { statusCode: 404, message: ["Not Found"] };
      }
      const msg = res == null ? void 0 : res.errors[0].message.replace(/https?:\/\/[^\s]+/g, "");
      return {
        statusCode: 403,
        messages: [msg]
      };
    }
  } catch (e) {
    const errorMessage = ((_j = e.message) == null ? void 0 : _j.replace(/https?:\/\/[^\s]+/g, "")) || "Unknown error";
    const statusCode = e.statusCode || 500;
    try {
      if ("response" in e) {
        try {
          delete e.response;
        } catch {
        }
      }
      if ("request" in e) {
        try {
          delete e.request;
        } catch {
        }
      }
      if ("config" in e) {
        try {
          delete e.config;
        } catch {
        }
      }
    } catch (cleanupError) {
    }
    try {
      if ((_l = (_k = res == null ? void 0 : res.data) == null ? void 0 : _k.guaqi) == null ? void 0 : _l.go) {
        delete res.data.guaqi.go;
      }
    } catch {
    }
    rawGoData = null;
    pageData = null;
    res = null;
    console.error("Page API error:", errorMessage);
    return {
      statusCode,
      messages: [errorMessage]
    };
  }
});

export { page as default };
