import { c as defineEventHandler, l as getQuery } from '../../_/nitro.mjs';
import { g as getClients } from '../../_/getClients.mjs';
import qrcode$1 from 'qrcode';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const qrcode = defineEventHandler(async (event) => {
  try {
    const allowedHosts = await getClients(event);
    if (!allowedHosts.includes(event.context.host)) {
      event.node.res.statusCode = 503;
      return "Service Unavailable";
    }
    const query = getQuery(event);
    const str = query.str;
    if (!str) {
      return {
        code: 400,
        msg: "\u53C2\u6570\u9519\u8BEF"
      };
    }
    const buffer = await qrcode$1.toBuffer(str, {
      type: "png",
      width: 300,
      height: 300,
      margin: 0
    });
    event.node.res.setHeader("Content-Type", "image/png");
    return buffer;
  } catch (error) {
    console.error("[qrcode] Error:", error);
    event.node.res.statusCode = 500;
    return "Internal Server Error";
  }
});

export { qrcode as default };
