import { c as defineEventHandler, f as readBody, p as pageCache, u as useRuntimeConfig, g as getCookie, w as wpClient } from '../../_/nitro.mjs';
import { h as htmlToBlocks } from '../../_/htmltoblocks.mjs';
import { g as global, m as modules, p as pages, f as footer, h as header } from '../../_/settings.mjs';
import { s as storeTokens } from '../../_/cookie.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';
import 'cheerio';
import 'quick-lru';

function escapeGraphQLString(str) {
  return str.replace(/\\/g, "\\\\").replace(/"/g, '\\"').replace(/\n/g, "\\n").replace(/\r/g, "\\r");
}
const viewerData = (editStatus) => {
  let roles = "";
  if (editStatus) {
    roles += `
          canBuilder
          apiSecret
          clients
          client
          server
        `;
  }
  return `avatar {
            url
          }
          gqCover
          databaseId
          gqRegisteredDate
          name
          gqVIP
          gqLevel
          gqCredit
          gqNotification
          gqTicket
          gqMoney
          gqSlug
          gqUserRef
          gqVerify {
            icon
            id
            name
          }
          gqVipExpired
          gqUserSocketToken
          gqRoles {
            ${roles}
            media {
              audio {
                can
                count
                size
                max
              }
              file {
                can
                count
                size
                max
              }
              attachment {
                can
                count
                size
                max
              }
              image {
                can
                count
                size
                max
              }
              video {
                can
                count
                size
                max
              }
            },
            isAdmin
            userCan
          }`;
};
const couponStr = `fragment CouponFields on GqCouponObject {
          createdAt
          description
          expiredAt{
            hasExpired
            expiredTime
          }
          faceValue
          code
          status
          restrictedProduct {
            id
            name
            slug
          }
          allowPush
          redeem{
            text
            type
            money
            credit
            level
            custom
          }
          useRestrict{
            users{
              id
              name
              gqSlug
            }
            levels
            type
          }
          type
          name
          restrictedType
        }`;
const query$1 = (event) => {
  const ip = event.context.ip;
  return {
    media: {
      getLibrary: (data) => {
        return `{
          mediaItems(where: {mimeTypeIN: ${data.mimeTypeIN}}, first: 24,after: "${data.after || ""}") {
            edges {
              cursor
              node {
                altText
                databaseId
                caption
                mimeType
                title
                sourceUrl
                mediaItemUrl
                fileSize
                mediaDetails {
                  height
                  width
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }`;
      }
    },
    account: {
      index: (data) => {
        return `{
        ${!data.after ? `viewer {
            gqFollowers
            gqFollowing
            gqPostCount
            gqTopicCount
            gqAnswerCount
          }` : ""}
          guaqi {
            profile {
              single{
                content(first: ${data.first || ""},after:"${data.after || ""}" ) {
                  edges {
                    cursor
                    node {
                      actionType
                        createdAt
                        description
                        targetData {
                          image
                          slug
                          content
                          title
                        }
                        id
                        targetType
                    }
                  }
                  pageInfo {
                    startCursor
                    hasPreviousPage
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
      },
      withdrawn: (data) => {
        return `mutation {
          gqWithdrawPromotion(input: {}) {
            success
          }
        }`;
      },
      withdrawalList: (data) => {
        return `query MyQuery {
          guaqi {
            account {
              withdrawal(after: "${data.after || ""}", first: ${data.first || 10}) {
                edges {
                  cursor
                  node {
                    amount
                    commission
                    createdAt
                    currency
                    finalAmount
                    id
                    rate
                    status
                    account
                    channel 
                  }
                }
                pageInfo {
                  hasNextPage
                  endCursor
                }
              }
            }
          }
        }`;
      },
      promotion: (data) => {
        return `{
          guaqi {
            account {
              promotion {
                info {
                  level1Income
                  level2Income
                  level3Income
                  totalIncome
                  withdrawn
                  userPromotion {
                    allow
                    cycle
                    permissions
                    proportions {
                      level3
                      level2
                      level1
                    }
                    levelTotal
                    statistics {
                      closed
                      currency
                      paid
                      waiting
                      withdrawable
                      withdrawn
                    }
                  }
                }
              }
            }
          }
        }`;
      },
      promotionUsers: (data) => {
        return `{
          guaqi {
            account {
              promotion {
                users(first: ${data.first}, after: "${data.after || ""}") {
                  edges {
                    cursor
                    node {
                      databaseId
                      name
                      email
                      gqSlug
                      avatar{
                        url
                      }
                      gqParent{
                        databaseId
                      }
                      gqParentParent{
                        databaseId
                      }
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
      },
      promotionList: (data) => {
        return `{
          guaqi {
            account {
              promotion {
                list(first: ${data.first}, after: "${data.after || ""}") {
                  edges {
                    node {
                      commission
                      commissionRate
                      createdAt
                      finalAmount
                      level
                      orderData
                      status
                      currency
                      fromUser {
                        avatar {
                          url
                        }
                        databaseId
                        name
                        gqSlug
                      }
                    }
                    cursor
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
      },
      settings: (data) => {
        return `{
         guaqi {
          account {
            settings(userId: ${parseInt(data.userId)}) {
              avatar {
                databaseId
                url
              }
              cover
              coverRandom {
                sourceUrl
                databaseId
              }
              thirdParty {
                bind
                name
              }
              displayName
              email
              phone
              socialBind
              addresses{
                index
                type
                country{
                  geonameId
                  name
                }
                province{
                  geonameId
                  name
                }
                city{
                  geonameId
                  name
                }
                district{
                  geonameId
                  name
                }
                postcode
                address
                addressString
                dialCode
                phone
                name
                default
              }
            }
          }
        }
        }`;
      },
      wealth: (data) => {
        return `{
          guaqi {
            account {
              wealth(first: ${data.first}, after: "${data.after || ""}", type: ${data.type}) {
                pageInfo {
                  hasNextPage
                  endCursor
                }
                edges {
                  node {
                    actionType
                    createdAt
                    credit
                    currentCredit
                    currency
                    description
                    id
                    taegetId
                    targetData {
                      content
                      id
                      image
                      slug
                      title
                    }
                    targetType
                  }
                }
              }
            }
          }
        }`;
      },
      task: (data) => {
        return `{
          guaqi {
            account {
              task {
                register {
                  ...TaskItemFields
                }
                create_post {
                  ...TaskItemFields
                }
                create_comment {
                  ...TaskItemFields
                }
                create_topic {
                  ...TaskItemFields
                }
                like {
                  ...TaskItemFields
                }
                liked {
                  ...TaskItemFields
                }
                follow {
                  ...TaskItemFields
                }
                followed {
                  ...TaskItemFields
                }
                collection {
                  ...TaskItemFields
                }
                collectioned {
                  ...TaskItemFields
                }
              }
            }
          }
        }
          
        fragment TaskItemFields on GqTaskItem {
          first
          total
          today
          date
        }`;
      },
      ticket: (data) => {
        return `{
          guaqi {
            account {
              ticket {
                documents {
                  name
                  thumb {
                    sourceUrl
                  }
                  description
                }
                ticketList(first: ${data.first}, after: "${data.after || ""}"){
                  edges {
                    cursor
                    node {
                      id
                      status
                      ticketGroup
                      ticketTitle
                      ticketType
                      read
                      content
                      createdAt
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
      },
      closeTicket: (data) => {
        return `{
          guaqi {
            account {
              ticket {
                closeTicket(group: ${data.group})
              }
            }
          }
        }`;
      },
      ticketChat: (data) => {
        return `{
          guaqi {
            account {
              ticket{
                ticketChat(group: ${data.group}){
                  id
                  from{
                    avatar {
                      url
                    }
                    name
                    databaseId
                  }
                  to{
                    avatar {
                      url
                    }
                    name
                    databaseId
                  }
                  fromId
                  ticketGroup
                  ticketType
                  ticketTitle
                  toId
                  content
                  createdAt
                  read
                  status
                }
              }
            }
          }
        }`;
      },
      creator: () => {
        return `{
          guaqi {
            account {
              creator {
                postCount
                topicCount
                commentCount
                next {
                  level
                  credit
                }
              }
            }
          }
        }`;
      },
      coupon: (data) => {
        return `{
          guaqi {
            account {
              coupon {
                list(after: "${data.after || ""}", first: ${data.first || 16}, type: "${data.type || "register"}") {
                  edges{
                    cursor
                    node{
                      ...CouponFields
                    }
                  }
                  pageInfo{
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }
        ${couponStr}`;
      },
      canPushList: (data) => {
        return `{
          guaqi {
            account {
              coupon {
                canPushList(after: "${data.after || ""}", first: ${data.first || 16}, type: "${data.type || ""}") {
                  edges{
                    cursor
                    node{
                      ...CouponFields
                    }
                  }
                  pageInfo{
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }
          ${couponStr}`;
      },
      couponUse: (data) => {
        return `{
          guaqi {
            account {
              coupon {
                use(couponCode: "${data.couponCode}")
              }
            }
          }
        }`;
      },
      couponExtract: (data) => {
        return `{
          guaqi {
            account {
              coupon{
                extract(couponKey: "${data.couponKey}")
                {
                  ...CouponFields
                }
              }
            }
          }
        }
           ${couponStr}  
        `;
      },
      couponItem: (data) => {
        return `{
          guaqi {
            account {
              coupon {
                item(couponCode: "${data.couponCode}") {
                  ...CouponFields
                }
              }
            }
          }
        }
        ${couponStr}  
        `;
      },
      couponHistory: (data) => {
        return `{
          guaqi {
            account {
              coupon{
                history(after: "${data.after || ""}", first: ${data.first || 16}){
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                  edges {
                    cursor
                    node {
                      createdAt
                      content
                      from {
                      name
                      gqSlug
                    }
                    to{
                      name
                      gqSlug
                    }
                  }
                }
              }
            }
          }
        }
      }`;
      },
      couponPush: (data) => {
        return `{
          guaqi {
            account {
              coupon {
                push(couponCode: "${data.couponCode}", toUserId: ${data.toUserId})
              }
            }
          }
        }`;
      },
      searchOrder: (data) => {
        return `{
          guaqi {
            account {
              orders {
                searchOrder(keyword: "${data.keyword || ""}") {
                  edges {
                    node {
                      createdAt
                      finalAmount
                      currency
                      price
                      product {
                        title
                        slug
                        thumbnail
                        sku
                        actionType
                      }
                      orderType
                      orderStatus
                      paymentMethod
                      orderId
                      id
                      productType
                    }
                  }
                  pageInfo {
                    endCursor
                    hasNextPage
                  }
                }
              }
            }
          }
        }`;
      },
      orderInfo: (data) => {
        return `{
          guaqi {
            account {
              orders {
                orderInfo(orderId: "${data.orderId}") {
                  createdAt
                  orderAmount
                  currency
                  price
                  finalAmount
                  count
                  id
                  paymentMethod
                  product {
                    title
                    slug
                    thumbnail
                    sku
                    actionType
                  }
                  orderId
                  orderStatus
                  orderType
                  productType
                }
              }
            }
          }
        }`;
      },
      orders: (data) => {
        return `{
          guaqi {
            account {
              orders {
                list(after: "${data.after || ""}", first: ${data.first || 12}, status: "${data.status || "all"}", orderType: "${data.orderType || "all"}") {
                  edges {
                    node {
                      createdAt
                      finalAmount
                      currency
                      price
                      product {
                        title
                        slug
                        thumbnail
                        sku
                        actionType
                      }
                      orderType
                      orderStatus
                      paymentMethod
                      orderId
                      id
                      productType
                    }
                  }
                  pageInfo {
                    endCursor
                    hasNextPage
                  }
                }
              }
            }
          }
        }`;
      },
      verify: (data) => {
        return `{
          guaqi {
            account {
              verify(keys: ["${data.keys.join('","')}"],ids: ["${data.ids.join(
          '","'
        )}"]) {
                id
                moneyPaid
                creditPaid
                pay {
                  credit
                  money
                }
                status
              }
            }
          }
        }`;
      }
    },
    profile: {
      follow: (data) => {
        return `{
          guaqi {
            profile {
              single {
                follow(userId: ${parseInt(data.userId || 0, 10)}, type: "${data.type}", first: ${data.first || 20}, after: "${data.after || ""}") {
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                  edges {
                    node {
                      createdAt
                      id
                      user {
                        avatar {
                          url
                        }
                        gqFollowed
                        gqFollowers
                        gqFollowing
                        gqLevel
                        gqVIP
                        gqSlug
                        name
                        databaseId
                      }
                    }
                  }
                }
              }
            }
          }
        }`;
      },
      collection: (data) => {
        return `{
           guaqi {
            profile {
              single {
                collection(first: ${data.first || 10}, after: "${data.after || ""}", userId: ${parseInt(data.userId || 0, 10)}, actionType: "${data.actionType || ""}") {
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                  edges {
                    node {
                      contentId
                      actionType
                      createdAt
                      id
                      targetType
                      targetData {
                        content
                        image
                        slug
                        title
                      }
                    }
                  }
                }
              }
            }
          }
        }`;
      },
      answers: (data) => {
        let stati = "";
        if (data.isCreator) {
          stati = "PENDING,PUBLISH";
        } else {
          stati = "PUBLISH";
        }
        return `{
          communityAnswers(where: {author: ${data.userId},stati: [${stati}], orderby: {field: DATE, order: DESC}},first: ${data.first || 10}, after: "${data.after || ""}") {
            edges {
              node {
                gqSlug
                commentCount
                excerpt
                dateGmt
                date
                databaseId
                status
                author {
                  node {
                    avatar {
                      url
                    }
                    gqSlug
                    name
                  }
                }
                gqParent {
                  gqSlug
                  title
                  author {
                    node {
                      avatar {
                        url
                      }
                      gqSlug
                      name
                    }
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
      }`;
      },
      getLoginTopicList: (data) => {
        return `{
          communityTopics(first:${data.ids.length},where: {in: [${data.ids.join(
          ","
        )}]}) {
            edges {
              node {
                databaseId
                terms {
                  nodes {
                    communityCatMetas {
                      name
                    }
                    gqSlug
                    databaseId
                    taxonomyName
                  }
                }
                topicContent {
                  topicExcerpt {
                    video{
                      src
                      thumb
                      name
                    }
                    text
                    iframe
                    gallery
                    audio{
                      src
                      thumb
                      name
                    }
                    file {
                      ext
                      size
                      src
                      name
                      unzipPassword
                      extractionCode
                    }
                  }
                  bounty {
                    deadline
                    type
                    currency
                    value
                    target
                    targetList {
                      id
                      name
                      gqSlug
                      avatar {
                        url
                      }
                    }
                  }
                  role {
                    type
                    value
                    can
                    postAuthor
                  }
                  vote {
                    deadline
                    list {
                      text
                      vote
                    }
                    postId
                    type
                    total
                    voted
                    picked
                    hasExpired
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }`;
      },
      topics: (data) => {
        let stati = "";
        if (data.isCreator) {
          stati = "PENDING,PUBLISH";
        } else {
          stati = "PUBLISH";
        }
        return `{
          communityTopics(first: ${data.first || 10}, after: "${data.after || ""}", where: {stati: [${stati}],author: ${data.userId}}) {
            edges {
              node {
                author {
                  node {
                    avatar {
                      url
                    }
                    name
                    gqVIP
                    gqLevel
                    databaseId
                    gqSlug
                  }
                }
                  terms {
                  nodes {
                    communityCatMetas {
                      name
                    }
                    gqSlug
                    databaseId
                    taxonomyName
                  }
                }
                viewsCache
                title
                ipInfo
                topicContent {
                  bounty {
                    deadline
                    type
                    value
                    currency
                    target
                    targetList {
                      id
                      name
                      gqSlug
                      avatar {
                        url
                      }
                    }
                  }
                  role {
                    type
                    value
                    can
                    postAuthor
                  }
                  vote {
                    deadline
                    list {
                      text
                      vote
                    }
                    postId
                    type
                    total
                    voted
                    picked
                    hasExpired
                  }
                }
                commentCount
                collectionCount
                likeCount
                gqSlug
                status
                databaseId
                dateGmt
                date
                terms {
                  nodes {
                  communityCatMetas {
                    name
                  }
                    databaseId
                    gqSlug
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }`;
      },
      posts: (data) => {
        let stati = "";
        if (data.isCreator) {
          stati = "PENDING,PUBLISH";
        } else {
          stati = "PUBLISH";
        }
        return `{
           posts(after: "${data.after || ""}",first: ${data.first || 20},where: {stati: [${stati}],author: ${data.userId}, orderby: {field: DATE, order: DESC}}) {
            pageInfo {
              endCursor
              hasNextPage
            }
            edges {
              node {
                title
                databaseId
                status
                date
                dateGmt
                gqSlug
                categories {
                  nodes {
                    gqSlug
                    name
                  }
                }
                commentCount
                viewsCache
                likeCount
                banner {
                  sourceUrl(size: MEDIUM_LARGE)
                }
                autoThumb
                featuredImage {
                  node {
                    sourceUrl(size: MEDIUM_LARGE)
                  }
                }
                gqMetas {
                  type
                }
              }
            }
          }
        }`;
      },
      comments: (data) => {
        let stati = "";
        if (data.isCreator) {
          stati = "APPROVE,HOLD";
        } else {
          stati = "APPROVE";
        }
        return `{
          comments(after: "${data.after || ""}",first: ${data.first || 20},where: {statusIn: [${stati}],userId: ${data.userId || 0},contentId: ${data.postId || 0},parent: ${data.parentId || 0}}) {
              pageInfo {
                endCursor
                hasNextPage
              }
              edges {
                cursor
                node {
                  commentAuthor {
                    avatar {
                      url
                    }
                    databaseId
                    gqSlug
                    name
                  }
                  status
                  dateGmt
                  parent {
                    node {
                      author {
                        name
                      }
                    }
                  }
                  likeCount
                  gqImages
                  databaseId
                  content
                  gqCommentPost {
                    gqPostType
                    gqSlug
                    title
                  }
                }
              }
            }
        }`;
      }
    },
    auth: {
      pageData: (data) => {
        return `{
          guaqi {
            loginData(path: "${data.path}",args: """${JSON.stringify(
          data.args
        )}""")
          }
        }`;
      },
      login: (data) => {
        return `mutation {
          login(input: {provider: ${data.provider}, credentials: {password: "${data.password}", username: "${data.username}"}}) {
              authToken
              authTokenExpiration
              refreshToken
              user {
                ${viewerData(data == null ? void 0 : data.editStatus)}
              }
          }
      }`;
      },
      register: (data) => {
        var _a;
        return `mutation {
        registerUser(input: {password: "${data.password}",phoneOrEmail:"${data.phoneOrEmail}",username: "placeholder",email: "placeholder@placeholder.placeholder",
        captchaInput: "${data.captchaInput}", captchaSign: "${data.captchaSign}",inviteCode: "${(_a = data.inviteCode) != null ? _a : ""}", verificationInput: ${data.verificationInput},verificationSign:"${data.verificationSign}",timestamp:"${data.timestamp}",action: "${data.action || ""}"}) {
          user {
            auth {
              authToken
              refreshToken
              authTokenExpiration
            }
            ${viewerData(data == null ? void 0 : data.editStatus)}
          }
        }}`;
      },
      captcha: (data) => {
        var _a;
        return ` {
        guaqi{ utils{
          captcha(phoneOrEmail: "${data.phoneOrEmail}",type:"${data.type || ""}",action:"${(_a = data.action) != null ? _a : ""}") {
            base64
            captchaSign
            timestamp
            action
            type
          }
        }
      }}`;
      },
      resetPassword: (data) => {
        return ` mutation {
        gqResetPassword(input: {phoneOrEmail: "${data.phoneOrEmail}",password: "${data.password}",verificationSign: "${data.verificationSign}",verificationInput: "${data.verificationInput}",captchaSign: "${data.captchaSign}",captchaInput: "${data.captchaInput}",timestamp: "${data.timestamp}",action: "${data.action}"}) {
          status
        }
      }`;
      },
      verifyCode: (data) => {
        return ` {
        guaqi{ utils{
          verifyCode(captchaSign: "${data.captchaSign}", captchaInput: "${data.captchaInput}",phoneOrEmail: "${data.phoneOrEmail}",timestamp: "${data.timestamp}",verificationSign: "${data.verificationSign}",verifyData: """${data.verifyData || ""}""",verificationInput: "${data.verificationInput}",action: "${data.action || ""}",type: "${data.type || ""}")
        }
      }}`;
      },
      captchaVerify: (data) => {
        return ` {
        guaqi{ utils{
          captchaVerify(captchaSign: "${data.captchaSign}", captchaInput: "${data.captchaInput}",phoneOrEmail: "${data.phoneOrEmail}",timestamp: "${data.timestamp}",type: "${data.type || ""}",action: "${data.action || ""}")
        }
      }}`;
      },
      getCode: (data) => {
        return ` {
          guaqi{ utils{
            getCode(captchaSign: "${data.captchaSign}", captchaInput: "${data.captchaInput}", lang: "${data.lang}", phoneOrEmail: "${data.phoneOrEmail}", siteUrl: "${data.siteUrl}",timestamp:"${data.timestamp}",action: "${data.action || ""}",type: "${data.type || ""}")
          }}}`;
      },
      viewer: (data) => {
        var _a;
        const str = `viewer {
                ${viewerData((_a = data == null ? void 0 : data.page) == null ? void 0 : _a.editStatus)}
              }`;
        return `{${str}}`;
      }
    },
    search: {
      user: (data) => {
        let ids = "";
        if (data.ids) {
          ids = `,include: [${data.ids}]`;
        }
        if (data.key) {
          ids = "";
        }
        return `{
        users(where: {searchColumns: DISPLAY_NAME,search: "${data.key}"${ids}},first: ${data.first || 30}) {
          nodes {
            avatar {
              url 
            }
            databaseId
            name
            gqVIP
            gqLevel
            gqSlug
          }
    }}`;
      }
    },
    utils: {
      getChangelogs: (data) => {
        const str = `{
              guaqi {
                utils {
                  getChangelogs(id: ${parseInt(data.id) || 0},first: ${data.first || 20},after: "${data.after || ""}") {
                    edges {
                      cursor
                      node {
                        createdAt
                        data
                        description
                        formId
                        status
                        userId
                      }
                    }
                    pageInfo {
                      hasNextPage
                      endCursor
                    }
                  }
                }
          }}`;
        return str;
      },
      getCommunityTerm: (data) => {
        return `{
          communityCat(id: ${data.termId},idType: DATABASE_ID) {
            name
            databaseId
            thumb{
              sourceUrl(size: MEDIUM_LARGE)
            }
            gqSlug
            count
            subscribers
            subscribed
            communityCatMetas {
              isJoin
              memberCount
              settings {
                joinRole {
                  level
                  pay {
                    type
                    value
                  }
                  type
                }
                topicCan{
                  can
                  levels
                }
                allowAudio
                allowBounty
                allowFile
                allowImage
                allowVideo
                allowVote
                pendingLimit
                publish
              }
              description
              name
              admin {
                avatar {
                  url
                }
                name
                databaseId
              }
            }
          }
        }`;
      },
      socialLoginBack: (data) => {
        return `{
          guaqi {
            utils {
              socialLoginCallback(code: "${data.code}", 
              provider: ${data.type}, 
              state: "${data.state}"
              ) {
                ... on User {
                  auth {
                    authToken
                    authTokenExpiration
                    refreshToken
                  }
                  ${viewerData()}
                }
                ... on GqSocialBound {
                    email
                    phone
                    key
                }
              }
            }
          }
        }`;
      },
      socialLogin: (data) => {
        return `{
          guaqi {
            utils {
              socialLogin(provider: ${data.provider}) {
                name
                clientId
                authorizationUrl
                state
              }
            }
          }
        }`;
      },
      search: (data) => {
        return ` {
          posts(first: 20, where: {search: "${data.key || ""}"}) {
            edges {
              node {
                gqSlug
                title
                gqPostType
                commentCount
                viewsCache
                likeCount
                collectionCount
                autoThumb
                featuredImage {
                  node {
                    sourceUrl
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }`;
      },
      getTopic: (data) => {
        return `{
          communityTopic(id: ${data.id}, idType: DATABASE_ID) {
          topicContent {
            topicExcerpt {
                  video{
                    src
                    thumb
                    name
                  }
                  text
                  iframe
                  gallery
                  audio{
                    src
                    thumb
                    name
                  }
                  file {
                    ext
                    name
                    unzipPassword
                    extractionCode
                    size
                    src
                  }
                }
                bounty {
                  deadline
                  type
                  value
                  target
                  currency
                  targetList {
                    databaseId
                    name
                    gqSlug
                  }
                }
                role {
                  type
                  value
                  can
                  termId
                  postId
                  postAuthor
                }
                vote {
                  deadline
                  list {
                    text
                    vote
                  }
                  postId
                  type
                  total
                  voted
                  picked
                  hasExpired
                }
            }
          }
        }`;
      },
      addressPicker: (data) => {
        return `{
          guaqi{ utils{
            addressPicker(geonameId: ${data.geonameId}, lang: "${data.lang}"){
              geonameId
              name
            }
          }
        }}`;
      },
      singleComment: (data) => {
        if (data.parentId) {
          return `{
          guaqi {
            community {
              single(articleID: ${data.postId}) {
                  flatReplies(first: ${data.replyCount || 5},after: "${data.after}",parentId: ${data.parentId}) {
                  commentCount
                  edges {
                  cursor
                    node {
                      databaseId
                      dateGmt
                      content
                      likeCount
                      status
                      gqImages
                      liked
                      parent {
                        node {
                          commentAuthor {
                            avatar {
                              url
                            }
                            databaseId
                            gqSlug
                            name
                          }
                        }
                      }
                      commentAuthor {
                        avatar {
                          url
                        }
                        databaseId
                        gqSlug
                        name
                      }
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
        }
        let orderby = "COMMENT_KARMA";
        if (data.orderby == "date") {
          orderby = "COMMENT_DATE";
        }
        return `{
          guaqi {
            community {
              single(articleID: ${data.postId}) {
                  comment(first: ${data.commentCount || 16},after: "${data.after || ""}",where: {parent: 0,postId: ${data.postId},orderby:${orderby},order: DESC}){
                  commentCount
                  edges {
                    cursor
                    node {
                      commentAuthor {
                          avatar {
                            url
                          }
                          databaseId
                          gqSlug
                          name
                        }

                      likeCount
          liked
          ipInfo

                      status
                      isSticky
                      databaseId
                      isAuthor
          isAdmin

                      content
                      dateGmt
                      gqImages
                      flatReplies(first: ${data.replyCount || 5}) {
                        commentCount
                        edges {
                        cursor
                          node {
                            databaseId
                            dateGmt
                            content
                            likeCount
                            status
                            gqImages
                            liked
                            parent {
                              node {
                                commentAuthor {
                                  avatar {
                                    url
                                  }
                                  databaseId
                                  gqSlug
                                  name
                                }
                              }
                            }
                            commentAuthor {
                              avatar {
                                url
                              }
                              databaseId
                              gqSlug
                              name
                            }
                          }
                        }
                        pageInfo {
                          hasNextPage
                          endCursor
                        }
                      }
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
          }
        }`;
      },
      topicSingle: (data) => {
        return `{
          guaqi {
            community {
              single(articleID: ${data.id}) {
              interactive {
                  collected
                  collectionCount
                  commentCount
                  likeCount
                  liked
                  shareCount
                  shared
                }
                content{
                  type
                  content
                  faq {
                      question
                      answer
                    }
                  bounty {
                    deadline
                    type
                    value
                    canAnswer
                    target
                    targetList {
                      id
                      name
                      gqSlug
                    }
                    answerList {
                      list(where: {orderby: {field: MENU_ORDER, order: DESC},parent: ${data.id}}, first: 16) {
                        edges {
                          node {
                            gqSlug
                            collectionCount
                            collected
                            likeCount
                            liked
                            commentCount
                            excerpt
                            dateGmt
                            databaseId
                            author {
                              node {
                                avatar {
                                  url
                                }
                                gqSlug
                                name
                              }
                            }
                          }
                        }
                        pageInfo {
                          hasNextPage
                          endCursor
                        }
                      }
                    }
                  }
                  role {
                    type
                    value
                    can
                    termId
                    postId
                    postAuthor
                  }
                  vote {
                    deadline
                    list {
                      text
                      vote
                    }
                    postId
                    type
                    picked
                    total
                    voted
                    hasExpired
                  }
                }
                  comment(first: ${data.commentCount || 5},where: {parent: 0,postId: ${data.id},orderby:COMMENT_KARMA,order: DESC}){
        commentCount
        edges {
          cursor
          node {
            commentAuthor {
                avatar {
                  url
                }
                databaseId
                gqSlug
                name
              }

            likeCount
liked
ipInfo

            status
            isSticky
            databaseId
            isAuthor
isAdmin

            content
            dateGmt
            gqImages
            flatReplies(first: ${data.replyCount || 1}) {
              commentCount
              edges {
              cursor
                node {
                  databaseId
                  dateGmt
                  content
                  likeCount
                  status
                  gqImages
                  liked
                  parent {
                    node {
                      commentAuthor {
                        avatar {
                          url
                        }
                        databaseId
                        gqSlug
                        name
                      }
                    }
                  }
                  commentAuthor {
                    avatar {
                      url
                    }
                    databaseId
                    gqSlug
                    name
                  }
                }
              }
              pageInfo {
                hasNextPage
                endCursor
              }
            }
          }
        }
        pageInfo {
          hasNextPage
          endCursor
        }
      }
              }
            }
          }
        }`;
      },
      answerList: (data) => {
        return `{
          guaqi {
            community {
              single(articleID: ${data.articleID}) {
                content {
                  bounty {
                    answerList {
                      list(first: 5, after: "${data.after || ""}") {
                        edges {
                          node {
                            gqSlug
                            collectionCount
                            collected
                            likeCount
                            liked
                            commentCount
                            excerpt
                            dateGmt
                            databaseId
                            author {
                              node {
                                avatar {
                                  url
                                }
                                gqSlug
                                name
                              }
                            }
                          }
                        }
                        pageInfo {
                          hasNextPage
                          endCursor
                        }
                      }
                    }
                  }
                }
              }
            }
          }    
        }`;
      },
      getPrivateMessageUsers: (data) => {
        return `{
          guaqi {
            utils {
              getPrivateMessageUsers(userId: ${data.userId},first: ${data.first || 20},after: "${data.after || ""}",type: ${data.type || "MESSAGE"}) {
                edges {
                  node {
                    id
                    content
                    createdAt
                    status
                    read
                    type
                    fromId
                    toId
                    from {
                      name
                      avatar {
                        url
                      }
                      databaseId
                    }
                    to {
                      avatar {
                        url
                      }
                      name
                      databaseId
                    }
                  }
                }
                pageInfo {
                  endCursor
                  hasNextPage
                }
              }
            }
          }
        }`;
      },
      readNotification: (data) => {
        return `{
          guaqi {
            utils {
              readNotification(id: ${data.id}, toId: ${data.toId})
            }
          }
        }`;
      },
      getPrivateMessage: (data) => {
        return `{
          guaqi {
            utils {
              getPrivateMessage(after: "${data.after || ""}", first: ${data.first || 20}, toId: ${data.toId}) {
                edges {
                  cursor
                  node {
                    id
                    content
                    createdAt
                    read
                    from {
                      avatar {
                        url
                      }
                      name
                      databaseId
                    }
                  }
                }
                pageInfo {
                  endCursor
                  hasNextPage
                }
              }
            }
          }
        }`;
      },
      getForm: (data) => {
        return `{
        guaqi{ utils{
          getForm(id: ${data.id})
        }
      }}`;
      },
      chatDelete: (data) => {
        return `{
        guaqi{ utils{
          chatDelete(id: ${data.id})
        }
      }}`;
      },
      getChatMessages: (data) => {
        return `{
          guaqi {
            utils {
              getChatMessages(room: "${data.room}", first: ${data.first || 50}, before: "${data.before || ""}") {
                edges {
                  cursor
                  node {
                    action
                    created_at
                    id
                    message
                    room
                    user {
                      gqSlug
                      databaseId
                      name
                      avatar {
                        url
                      }
                    }
                  }
                }
                pageInfo {
                  hasNextPage
                  startCursor
                }
              }
            }
          }
        }`;
      },
      chat: (data) => {
        return `{
          guaqi {
            utils {
              sendChat(text: "${escapeGraphQLString(data.text)}"){
                action
                created_at
                id
                message
                room
                signature
                user {
                  gqSlug
                  databaseId
                  name
                  avatar {
                    url
                  }
                }
              }
            }
          }
        }`;
      },
      getEmbed: (data) => {
        return `{
        guaqi{ utils{
          embed(url: "${data.url}")
        }
      }}`;
      },
      getSettings: (data) => {
        return ` {
          guaqi{
            utils {
            settings(client: "${(data == null ? void 0 : data.client) || ""}")
          }
        }
      }`;
      },
      getPostCoupons: (data) => {
        return `{
          guaqi {
            utils {
              getPostCoupons(postId: ${data.postId || 0},type: "${data.type || "cash"}",first: ${data.first || 16},after: "${data.after || ""}") {
                edges{
                  cursor
                  node{
                    ...CouponFields
                  }
                }
                pageInfo{
                  hasNextPage
                  endCursor
                }
              }
            }
          }
        }
        ${couponStr}  
        `;
      },
      createSettings: (data) => {
        return `{
          guaqi {
            utils {
              createSettings(type: "${data.type || "post"}",topic:${parseInt(
          data.topic || 0
        )},id: ${parseInt(data.id || 0)},nodeId: ${parseInt(
          data.nodeId || 0
        )}) {
                data {
                  categories {
                    name
                    databaseId
                  }
                  thumb {
                    sourceUrl
                    databaseId
                  }
                  content
                  title
                  canAnswer
                  slug
                  meta {
                    type
                    bounty {
                      type
                      deadline
                      value
                      target
                      currency
                      targetList{
                        databaseId
                        name
                        gqSlug
                        avatar {
                          url
                        }
                      }
                    }
                    vote {
                      deadline
                      type
                      value {
                        i
                        text
                        vote
                      }
                    }
                  }
                  node
                  tags {
                    databaseId
                    name
                  }
                  role {
                    type
                    value
                  }
                }
                settings {
                  allowAudio
                  allowBounty
                  allowCreate
                  allowAttachment
                  allowImage
                  allowVideo
                  allowVote
                  allowCategories {
                    databaseId
                    name
                  }
                }
              }
            }
          }
        }`;
      },
      getUserInfo: (data) => {
        return `{
          user(id: ${data.userId}, idType: DATABASE_ID) {
            avatar {
              url
            }
            databaseId
            name
            gqVIP
            gqVerify {
              icon
              name
            }
            gqSlug
            gqLevel
            gqRegisteredDate
            gqTopicCount
            gqFollowed
            gqCommentCount
            gqFollowers
            gqFollowing
            gqFollowed
            gqCover
          }
        }`;
      }
    },
    mutates: {
      addChangelog: (data) => {
        let res = `mutation {
          gqAddChangelog(input: {formId: ${data.formId},data: """${data.data}""",description: """${data.description}"""}) {
            success
            data
          }
        }`;
        return res;
      },
      notificationReadAll: (data) => {
        return `mutation {
          gqNotificationReadAll(input: {userId: ${data.userId}}) {
            success
          }
        }`;
      },
      createCommunityTag: (data) => {
        return `mutation {
          createCommunityTag(input: {name: "${data.name || ""}"}) {
            communityTag {
              gqSlug
              name
              thumb {
                sourceUrl
              }
              databaseId
            }
          }
        }`;
      },
      commentSticky: (data) => {
        return `mutation {
          gqCommentSticky(input: {commentId: ${data.commentId}}) {
            success
            isSticky
          }
        }`;
      },
      todoLike: (data) => {
        return `mutation {
          gqToggleTodo(input: {postId: ${data.postId},contentId: "${data.contentId}"}) {
            success
          }
        }`;
      },
      rating: (data) => {
        return `mutation {
          gqRatingsAdd(input: {id: ${data.id},type: "${data.type || ""}",sku: "${data.sku || 0}",rating: ${data.rating}}) {
            success
          }
        }`;
      },
      countAdd: (data) => {
        return `mutation {
          gqCountAdd(input: {postId: ${data.postId},type: "${data.type || ""}", index: ${data.index}}) {
            success
          }
        }`;
      },
      autoLogin: (data) => {
        return `mutation {
          gqAutoLogin(input: {token: "${data.token}"}) {
            user {
              auth {
                authToken
                authTokenExpiration
                refreshToken
              }
              ${viewerData()}
            }
          }
        }`;
      },
      socialCreateUser: (data) => {
        return `mutation{
          gqSocialCreateUser(
            input: {captchaInput: "${data.captchaInput || ""}", captchaSign: "${data.captchaSign || ""}", password: "${data.password || ""}", phoneOrEmail: "${data.phoneOrEmail || ""}", timestamp: "${data.timestamp || ""}", key: "${data.key || ""}", verificationInput: "${data.verificationInput || ""}", verificationSign: "${data.verificationSign || ""}", action: "${data.action || ""}"}
          ) {
            user {
              auth {
                authToken
                authTokenExpiration
                refreshToken
              }
              ${viewerData()}
            }
          }
        }`;
      },
      socialUnbind: (data) => {
        return `mutation {
          gqSocialUnbind(input: {key: "${data.key}"}) {
            success
          }
        }`;
      },
      createPost: (data) => {
        let mutation = `createPost`;
        let id = "";
        if (data.id) {
          mutation = `updatePost`;
          id = `id: ${parseInt(data.id)},`;
        }
        return `mutation {
          ${mutation}(input: {${id}status: PUBLISH,title: "${data.title}", content: """${data.content}""",categories: {nodes: {id: ${data.category}}}, cover: ${data.cover || 0}, gqPostRoles: {value: "${data.roles.value}", type: ${data.roles.type}}}) {
            post {
              gqSlug
            }
          }
        }`;
      },
      deleteMedias: (data) => {
        return `mutation {
          gqDeleteMedias(input: {ids: [${data.ids.join(",")}]}) {
            success
          }
        }`;
      },
      deleteAction: (data) => {
        return `mutation {
          gqDeleteAction(input: {id: ${data.id},type: "${data.type}"}) {
            success
          }
        }`;
      },
      withdrawal: (data) => {
        return `mutation {
          gqWithdrawal(input: {withdrawn:${data.withdrawn},currency: "${data.currency}", account: "${data.account}", channel: "${data.channel}"}) {
            success
          }
        }`;
      },
      addressDelete: (data) => {
        return `mutation {
          gqAddressDelete(input: {index: ${data.index}}) {
            success
            data {
              index
              address
              addressString
              city {
                geonameId
                name
              }
              country {
                geonameId
                name
              }
              default
              dialCode
              district {
                geonameId
                name
              }
              name
              phone
              postcode
              province {
                geonameId
                name
              }
              type
            }
          }
        }`;
      },
      addressSetDefault: (data) => {
        return `mutation {
          gqAddressSetDefault(input: {index: ${data.index}}) {
            success
            data {
              index
              address
              addressString
              city {
                geonameId
                name
              }
              country {
                geonameId
                name
              }
              default
              dialCode
              district {
                geonameId
                name
              }
              name
              phone
              postcode
              province {
                geonameId
                name
              }
              type
            }
          }
        }`;
      },
      saveAddress: (data) => {
        let index = data.index != null ? `,index: ${data.index}` : ``;
        return ` mutation {
        gqAddressCreate(
          input: {address: "${data.address || ""}", addressString: "${data.addressString || ""}", 
          city: {geonameId: ${data.city.geonameId || 0}, name: "${data.city.name || ""}"}, country: {geonameId: ${data.country.geonameId || 0}, 
          name: "${data.country.name || ""}"}, default: ${data.default || false}, district: {geonameId: ${data.district.geonameId || 0}, name: "${data.district.name || ""}"}, 
          name: "${data.name || ""}", dialCode: "${data.dialCode || ""}", phone: "${data.phone || ""}", postcode: "${data.postcode || ""}", province: {geonameId: ${data.province.geonameId || 0}, name: "${data.province.name || ""}"},${index} type: ${data.type || "SELECTED"}}
        ) {
          success
          data {
            index
            address
            addressString
            city {
              geonameId
              name
            }
            country {
              geonameId
              name
            }
            default
            dialCode
            district {
              geonameId
              name
            }
            name
            phone
            postcode
            province {
              geonameId
              name
            }
            type
          }
        }
      }
      `;
      },
      deletePrivateMessage: (data) => {
        return `mutation {
          gqDeletePrivateMessage(input: {id: ${parseInt(data.id)},toId: ${parseInt(data.toId)}}){
            id
          }
        }`;
      },
      submitForm: (data) => {
        return `mutation {
          gqSubmitForm(input: {formId: ${data.formId},type: "${data.type}",verifyId: "${data.verifyId || ""}",data: """${data.data}"""}) {
            success
          }
        }`;
      },
      createReport: (data) => {
        if (data.imgs) {
          data.imgs = data.imgs.join(",");
        }
        return `mutation {
          gqCreateReport(input: {content: "${data.content}",type: "${data.type}",imgs: [${data.imgs}],postId: ${data.postId},postType: "${data.postType}"}) {
           message
           success
          }
        }`;
      },
      pay: (data) => {
        return `mutation {
          gqPay(input: {postId: ${data.postId || 0},finalPrice: ${data.finalPrice || 0},ip: "${ip || ""}", payment: "${data.payment || ""}", type: "${data.type || ""}", slug: "${data.slug || ""}", args: """${data.args}""", couponCode: "${data.couponCode || ""}"}) {
            success
            data
          }
        }`;
      },
      payResult: (data) => {
        return `mutation {
          gqPayResult(input: {orderId: "${data.orderId || ""}",query: """${JSON.stringify(data.query)}"""}) {
            success
            info
          }
        }`;
      },
      payCheck: (data) => {
        return `mutation {
          gqPayCheck(input: {orderId: "${data.orderId || ""}"}) {
            success
            info
          }
        }`;
      },
      createComment: async (data) => {
        let images = data.images.join(",");
        let imageInput = "";
        if (data.images.length > 0) {
          imageInput = `,images:[${images}]`;
        }
        let sketchInput = "";
        if (data.sketch) {
          sketchInput = `,sketch:${data.sketch}`;
        }
        let on = "";
        if (data.commentOn) {
          try {
            data.commentOn = data.commentOn.split(".")[0];
          } catch (e) {
          }
          on = `,commentOn:${data.commentOn}`;
        }
        return `mutation {
        createComment(input: {parent: ${data.parent}${on},ip: "${ip || ""}", date: "${data.date}", content: """${data.content}"""${sketchInput}${imageInput}}) {
          comment{
            commentAuthor {
              avatar {
                url
              }
              databaseId
              gqLevel
              gqVIP
              gqSlug
              name
            }
            ipInfo
            status
            databaseId
            content
            gqImages
            parentDatabaseId
            parent {
                node {
                  commentAuthor {
                    avatar {
                      url
                    }
                    databaseId
                    gqLevel
                    gqVIP
                    gqSlug
                    name
                  }
                }
              }
            isAuthor
            isAdmin
            dateGmt
            likeCount
            liked
          }
        }
      }`;
      },
      createAnswer: (data) => {
        return `mutation {
          createCommunityAnswer(input: {id: ${data.id},topic: ${data.topic},content: """${data.content}"""}) {
            communityAnswer {
              status
            }
          }
        }`;
      },
      createTopic: (data) => {
        var _a, _b;
        let typeItem = ``;
        if ((_a = data.types) == null ? void 0 : _a.bounty) {
          typeItem = `,bounty:{type:${data.types.bounty.type},value:${data.types.bounty.value},deadline:"${data.types.bounty.deadline}",target:${data.types.bounty.target},targetList:[${data.types.bounty.targetList.join(",")}]}`;
        }
        if ((_b = data.types) == null ? void 0 : _b.vote) {
          let list = "[";
          for (let index = 0; index < data.types.vote.value.length; index++) {
            list += `{text:"${data.types.vote.value[index].text}",vote:${parseInt(data.types.vote.value[index].vote)}},`;
          }
          list = list.substring(0, list.length - 1);
          list += "]";
          typeItem = `,vote:{type:${data.types.vote.type},value:${list},deadline:"${data.types.vote.deadline}"}`;
        }
        let mutation = `createCommunityTopic`;
        let id = "";
        if (data.id) {
          mutation = `updateCommunityTopic`;
          id = `id: ${data.id},`;
        }
        let str = `mutation {
        ${mutation}(
          input: {status: PUBLISH,${id}ip: "${ip || ""}",communityCats: {nodes: {id: ${data.cat}}},gqPostTypes: {type: ${data.types.type}${typeItem}}, gqPostRoles: {value: "${data.roles.value}", type: ${data.roles.type}}, content: """${data.content}""",title:"${data.title}"}
        ) {
          communityTopic {
            author {
              node {
                avatar {
                  url
                }
                name
                gqVIP
                gqLevel
                databaseId
              }
            }
            viewsCache
            ipInfo
            status
            title
            topicContent {
              bounty {
                deadline
                type
                value
                target
                targetList {
                  id
                  name
                  gqSlug
                  avatar {
                    url
                  }
                }
              }
              role {
                type
                value
                can
              }
              vote {
                deadline
                list {
                  text
                  vote
                }
                postId
                type
                total
                voted
                picked
                hasExpired
              }
              topicExcerpt {
                    video{
                      src
                      thumb
                      name
                    }
                    text
                    iframe
                    gallery{
                    src
                    width
                    height
                    }
                    audio{
                      src
                      thumb
                      name
                    }
                    file {
                      ext
                      size
                      src
                      name
                      unzipPassword
                      extractionCode
                    }
                  }
            }
            gqSlug
            commentCount
            databaseId
            dateGmt
            terms {
              nodes {
                taxonomyName
                communityCatMetas {
                  name
                }
                gqSlug
                databaseId
              }
            }
          }
        }
      }`;
        return str;
      },
      joinNode: (data) => {
        var _a;
        return `mutation {
        gqCommunityJoin(input: {role: ${data.role}, userId: ${(_a = data.userId) != null ? _a : 0}, nodeId: ${parseInt(data.nodeId)}}) {
          success
          canTopic
          data{
            isJoin
            memberCount
            settings {
              joinRole {
                level
                pay {
                  type
                  value
                }
                type
              }
              topicCan{
                can
                levels
              }
              allowAudio
              allowBounty
              allowFile
              allowImage
              allowVideo
              allowVote
              pendingLimit
              publish
            }        
          }
        }
      }`;
      },
      follow: (data) => {
        return `mutation follow{
      gqToggleFollowUser(input: {userIdToFollow: ${data.id}}) {
        followStatus
        success
      }
    }`;
      },
      content: (data) => {
        return `mutation {
        gqToggleContent(input: {contentId: ${data.id || 0},actionType: "${data.actionType || ""}",targetType: "${data.targetType || ""}"}) {
          status
          success
        }
      }`;
      },
      sendMessage: (data) => {
        var _a, _b, _c;
        return `mutation {
        gqSendMessage(input: {to_id: ${(_a = data.to_id) != null ? _a : 0},image: ${(_b = data.image) != null ? _b : 0},content: """${(_c = data.content) != null ? _c : ""}"""}) {
          userId
          toId
          signature
          content
          timestamp
        }
      }`;
      },
      createTicket: (data) => {
        return `mutation {
        gqCreateTicket(input: {title: "${data.title}",content: "${data.content}",type: "${data.type}"}) {
          success
        }
      }`;
      },
      addVoteRecord: (data) => {
        return `mutation {
          gqAddVoteRecord(input: {postId: ${data.postId}, voteType: "${data.voteType}", voteData: [${data.voteData.join(",")}]}) {
            data {
              deadline
              list {
                text
                vote
              }
              postId
              type
              total
              voted
              picked
              hasExpired
            }
          }
        }`;
      },
      wealthTransfer: (data) => {
        return `mutation {
          gqWealthTransfer(input: {from: "${data.from}", to: "${data.to}", amount: ${data.amount}}) {
            success
          }
        }`;
      }
    },
    updateUser: (data) => {
      let input = "";
      let user = "";
      if (data.avatar) {
        input += `avatar: "${data.avatar}",`;
        user += `avatar { url }
`;
      }
      if (data.cover) {
        input += `cover: "${data.cover}",`;
        user += `gqCover
`;
      }
      if (data.displayName) {
        input += `displayName: "${data.displayName}",`;
        user += `name
`;
      }
      if (data.password) {
        input += `password: "${data.password}",`;
        user += `databaseId
`;
      }
      return `mutation {
      updateUser(input: {id: "${data.id}", ${input}}) {
        user {
          ${user}
        }
      }
    }`;
    },
    archive: {
      nodesList: (data) => {
        return `{
          communityCats(first: ${data.first || 20}, after: "${data.after || ""}") {
            edges {
              node {
                communityCatMetas {
                  admin {
                    avatar {
                      url
                    }
                    name
                    gqSlug
                  }
                  isJoin
                  memberCount
                  name
                  settings {
                    nodeType
                    topicCan {
                      can
                      levels
                    }
                    joinRole {
                      type
                    }
                  }
                  description
                }
                count
                databaseId
                gqSlug
                thumb {
                  sourceUrl
                }
              }
            }
            pageInfo {
              endCursor
              hasNextPage
            }
          }
        }`;
      },
      searchTerm: (data) => {
        let nameLike = "", after = "", search = "";
        if (data.key) {
          nameLike = `nameLike: "${data.key || ""}",`;
        }
        if (data.after) {
          after = `,after: "${data.after || ""}"`;
        }
        if (data.search) {
          search = `,search: "${data.search || ""}"`;
        }
        return `{
        terms(where: {${nameLike} taxonomies: ${data.type},lang:"default",orderby: ${data.orderby || "COUNT"}, order: DESC${search}},first: ${data.first || 20} ${after}) {
          edges {
            node {
              name
              gqSlug
              databaseId
              communityCatMetas {
                name
                memberCount
                isJoin
              }
              count
              thumb {
                sourceUrl
              }
            }
          }
          pageInfo {
            endCursor
            hasNextPage
          }
        }
      }`;
      }
    }
  };
};

const query = (event) => {
  return {};
};

const request = defineEventHandler(async (event) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u;
  try {
    const resolvePath = (obj, path) => {
      if (!path) return "";
      if (path.indexOf(".") === -1) return obj[path];
      const properties = path.split(".");
      return properties.reduce((acc, prop) => {
        return acc && acc[prop] !== void 0 ? acc[prop] : false;
      }, obj);
    };
    const body = await readBody(event);
    const action = body.action;
    if (action == "builder.sendSettings") {
      body.data.page_settings = Buffer.from(body.data.page_settings).toString(
        "base64"
      );
    }
    const device = body.device;
    const host = body.host || event.context.host;
    event.context.host = host;
    if (action == "utils.getSettings") {
      const pageSettings = await pageCache.get("gq_page_settings", host);
      if (pageSettings) {
        return pageSettings;
      }
    }
    let queryStr = "";
    let queryFn = null;
    try {
      const actionPrefix = action.split(".")[0];
      if (actionPrefix == "custom") {
        queryFn = query(event);
      } else {
        queryFn = query$1(event);
      }
    } catch (e) {
      queryFn = query$1(event);
    }
    const str = resolvePath(queryFn, action);
    const config = useRuntimeConfig();
    if (!str && !body.queryStr) {
      return {
        statusCode: 403,
        messages: ["action not found"]
      };
    }
    if (str) {
      queryStr = await str(body.data);
    } else if (body.queryStr) {
      queryStr = body.queryStr;
    }
    if (!queryStr) {
      return {
        statusCode: 403,
        messages: ["queryStr not found"]
      };
    }
    let lang = getCookie(event, "i18n_redirected");
    let currency = getCookie(event, "currency");
    if (!lang) {
      lang = body.lang;
    }
    if (!currency) {
      currency = body.currency;
    }
    const ip = event.context.ip || "";
    let opt = {
      method: "POST",
      headers: {
        "host": host,
        "X-Fe-Route": host,
        "X-Fe-Ua-Type": device,
        "X-Fe-Lang": lang,
        "X-Fe-Uuid": body.visitorId,
        "X-Fe-Currency": currency,
        "X-Fe-Ip": ip,
        "Content-Type": "application/json"
      },
      body: {
        query: queryStr
      }
    };
    let authorizationHeader = event.context.authToken ? `${event.context.authToken}` : null;
    if (authorizationHeader && !((_a = body.data) == null ? void 0 : _a.serverUrl)) {
      Object.assign(opt.headers, {
        authorization: authorizationHeader
      });
    }
    let url = config.private.apiBase;
    if ((_b = body.data) == null ? void 0 : _b.serverUrl) {
      url = body.data.serverUrl;
    }
    let res;
    try {
      res = await wpClient(url, {
        ...opt,
        timeout: 3e4,
        // 30秒超时
        retry: 0
        // 禁用自动重试，避免累积请求
      });
    } catch (fetchError) {
      const errorMessage = fetchError.message || "Request failed";
      console.error("GraphQL request failed:", errorMessage);
      throw fetchError;
    }
    if (!res.errors) {
      if ((_c = res.data) == null ? void 0 : _c.login) {
        storeTokens(event, res.data.login);
      }
      if ((_d = res.data) == null ? void 0 : _d.registerUser) {
        storeTokens(event, {
          authToken: res.data.registerUser.user.auth.authToken,
          refreshToken: res.data.registerUser.user.auth.refreshToken,
          authTokenExpiration: res.data.registerUser.user.auth.authTokenExpiration
        });
      }
      if ((_g = (_f = (_e = res.data) == null ? void 0 : _e.guaqi) == null ? void 0 : _f.utils) == null ? void 0 : _g.socialLoginCallback) {
        if (!((_h = res.data.guaqi.utils.socialLoginCallback) == null ? void 0 : _h.key)) {
          storeTokens(event, {
            authToken: res.data.guaqi.utils.socialLoginCallback.auth.authToken,
            refreshToken: res.data.guaqi.utils.socialLoginCallback.auth.refreshToken,
            authTokenExpiration: res.data.guaqi.utils.socialLoginCallback.auth.authTokenExpiration
          });
        }
      }
      if ((_j = (_i = res.data) == null ? void 0 : _i.gqSocialCreateUser) == null ? void 0 : _j.user) {
        storeTokens(event, res.data.gqSocialCreateUser.user.auth);
      }
      if ((_l = (_k = res.data) == null ? void 0 : _k.gqAutoLogin) == null ? void 0 : _l.user) {
        storeTokens(event, res.data.gqAutoLogin.user.auth);
      }
      const defaultSettings = {
        header,
        footer,
        pages,
        modules,
        global
      };
      if (action == "utils.getSettings") {
        if (!res.data.guaqi.utils.settings) {
          return {
            statusCode: 404,
            messages: ["settings not found"]
          };
        }
        let settings = null;
        let rawSettingsStr = null;
        try {
          if (!((_o = (_n = (_m = res.data) == null ? void 0 : _m.guaqi) == null ? void 0 : _n.utils) == null ? void 0 : _o.settings)) {
            settings = {
              page_settings: {
                desktop: defaultSettings,
                mobile: defaultSettings,
                tablet: defaultSettings
              }
            };
          } else {
            rawSettingsStr = res.data.guaqi.utils.settings;
            settings = JSON.parse(rawSettingsStr);
            if (!settings.page_settings) {
              settings.page_settings = {
                desktop: defaultSettings,
                mobile: defaultSettings,
                tablet: defaultSettings
              };
            }
          }
          pageCache.set("gq_page_settings", settings, null, host);
          return settings;
        } finally {
          if (rawSettingsStr && ((_q = (_p = res == null ? void 0 : res.data) == null ? void 0 : _p.guaqi) == null ? void 0 : _q.utils)) {
            delete res.data.guaqi.utils.settings;
          }
          rawSettingsStr = null;
        }
      }
      if ((_s = (_r = res == null ? void 0 : res.data) == null ? void 0 : _r.guaqi) == null ? void 0 : _s.loginData) {
        let rawLoginDataStr = null;
        let pageData = null;
        try {
          rawLoginDataStr = res.data.guaqi.loginData;
          pageData = JSON.parse(rawLoginDataStr);
          if (pageData.module) {
            Object.keys(pageData.module).forEach((key) => {
              var _a2, _b2, _c2;
              if ((((_a2 = pageData.module[key]) == null ? void 0 : _a2.type) == "content" || ((_b2 = pageData.module[key]) == null ? void 0 : _b2.gqPostType) == "community_answer") && ((_c2 = pageData.module[key]) == null ? void 0 : _c2.content)) {
                const originalContent = pageData.module[key].content;
                pageData.module[key].content = htmlToBlocks(originalContent);
              }
            });
          }
          if (rawLoginDataStr && ((_t = res == null ? void 0 : res.data) == null ? void 0 : _t.guaqi)) {
            delete res.data.guaqi.loginData;
          }
          res.data.guaqi.loginData = pageData;
        } finally {
          rawLoginDataStr = null;
        }
      }
      return res.data;
    } else {
      const msg = res.errors[0].message.replace(/https?:\/\/[^\s]+/g, "");
      return {
        statusCode: 403,
        messages: [msg]
      };
    }
  } catch (e) {
    const errorMessage = ((_u = e.message) == null ? void 0 : _u.replace(/https?:\/\/[^\s]+/g, "")) || "Unknown error";
    const statusCode = e.statusCode || 500;
    try {
      if ("response" in e) {
        try {
          delete e.response;
        } catch {
        }
      }
      if ("request" in e) {
        try {
          delete e.request;
        } catch {
        }
      }
      if ("config" in e) {
        try {
          delete e.config;
        } catch {
        }
      }
    } catch (cleanupError) {
    }
    console.error("API request error:", errorMessage);
    return {
      statusCode,
      messages: [errorMessage]
    };
  }
});

export { request as default };
