import process from 'node:process';globalThis._importMeta_=globalThis._importMeta_||{url:"file:///_entry.js",env:process.env};import { c as defineEventHandler, u as useRuntimeConfig, n as getRequestHeaders, f as readBody } from '../../_/nitro.mjs';
import crypto from 'crypto';
import QuickLRU from 'quick-lru';
import { fileURLToPath } from 'url';
import path from 'path';
import fs from 'fs';
import AdmZip from 'adm-zip';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

function getProjectRoot() {
  const __filename = fileURLToPath(globalThis._importMeta_.url);
  let currentDir = path.dirname(__filename);
  for (let i = 0; i < 5; i++) {
    if (fs.existsSync(path.join(currentDir, "nitro.json"))) {
      return currentDir;
    }
    currentDir = path.join(currentDir, "..");
  }
  return process.cwd();
}
const usedNonces = new QuickLRU({
  maxSize: 1e3
  // 最多缓存 10000 个 nonce
});
const nonceExpiryTime = 300;
function isNonceUsed(nonce) {
  const expiry = usedNonces.get(nonce);
  if (!expiry) {
    return false;
  }
  if (Date.now() > expiry) {
    usedNonces.delete(nonce);
    return false;
  }
  return true;
}
const upgrade = defineEventHandler(async (event) => {
  const config = useRuntimeConfig();
  const headers = getRequestHeaders(event);
  const signature = headers["signature"];
  const timestamp = headers["timestamp"];
  const nonce = headers["nonce"];
  const apiSecret = config.private.apiSecret;
  if (!signature || !timestamp || !nonce || !apiSecret) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  }
  const currentTime = Math.floor(Date.now() / 1e3);
  const requestTime = parseInt(timestamp, 10);
  if (Math.abs(currentTime - requestTime) > nonceExpiryTime) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Timestamp out of window" })
    };
  }
  if (isNonceUsed(nonce)) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Nonce has already been used" })
    };
  }
  const expectedSignature = crypto.createHmac("sha256", apiSecret).update(timestamp + nonce).digest("hex");
  if (signature !== expectedSignature) {
    return {
      statusCode: 403,
      body: JSON.stringify({ error: "Invalid signature" })
    };
  }
  usedNonces.set(nonce, Date.now() + nonceExpiryTime * 1e3);
  const body = await readBody(event);
  if (body.msg === "upgrade") {
    const client = body.client_url;
    if (!client) {
      return {
        statusCode: 403,
        body: JSON.stringify({ message: "Upgrade failed" })
      };
    }
    let urlObject;
    try {
      urlObject = new URL(client);
    } catch (error) {
      console.error("[upgrade] Invalid client URL:", error);
      return {
        statusCode: 400,
        body: JSON.stringify({ message: "Invalid URL" })
      };
    }
    const pathname = urlObject.pathname;
    const zipName = pathname.substring(pathname.lastIndexOf("/") + 1);
    const __filename = fileURLToPath(globalThis._importMeta_.url);
    let __dirname = path.dirname(__filename);
    __dirname = path.resolve(__dirname, "..");
    console.log("__dirname", __dirname);
    async function downloadZip(url, outputPath) {
      const controller = new AbortController();
      const timeoutId = setTimeout(() => controller.abort(), 6e4);
      try {
        const response = await fetch(url, {
          signal: controller.signal
        });
        clearTimeout(timeoutId);
        if (!response.ok) {
          throw new Error(`\u4E0B\u8F7D\u5931\u8D25: ${response.statusText}`);
        }
        const arrayBuffer = await response.arrayBuffer();
        const buffer = Buffer.from(arrayBuffer);
        fs.writeFileSync(outputPath, buffer);
      } catch (error) {
        clearTimeout(timeoutId);
        if (error.name === "AbortError") {
          throw new Error("\u4E0B\u8F7D\u8D85\u65F6");
        }
        throw error;
      }
    }
    try {
      const rootDir = getProjectRoot();
      const file = path.join(rootDir, zipName);
      await downloadZip(client, file);
      const currentTime2 = Math.floor(Date.now() / 1e3);
      const version = (config.private.gqVersion || "1_0_0").replace(/\./g, "_");
      const existingFiles = fs.readdirSync(rootDir);
      existingFiles.forEach((f) => {
        if (f.includes("_old_")) {
          fs.rmSync(path.join(rootDir, f), { recursive: true, force: true });
        }
      });
      const targets = ["public", "server", "nitro.json"];
      targets.forEach((target) => {
        const targetPath = path.join(rootDir, target);
        if (fs.existsSync(targetPath)) {
          fs.renameSync(targetPath, `${targetPath}_old_${version}_${currentTime2}`);
        }
      });
      const zip = new AdmZip(file);
      const entries = zip.getEntries();
      entries.forEach((e) => {
        if (e.entryName.startsWith("guaqi/") && !e.isDirectory) {
          const rel = e.entryName.slice("guaqi/".length);
          const dest = path.join(rootDir, rel);
          fs.mkdirSync(path.dirname(dest), { recursive: true });
          zip.extractEntryTo(e, path.dirname(dest), false, true, path.basename(dest));
        }
      });
      setTimeout(() => {
        process.exit(0);
      }, 1500);
      return {
        statusCode: 200,
        body: JSON.stringify({ message: "Upgrade success, system restarting..." })
      };
    } catch (error) {
      console.error("[Upgrade Error]:", error);
      return {
        statusCode: 500,
        body: JSON.stringify({ message: "Upgrade failed", error: error.message })
      };
    }
  }
  return {
    statusCode: 403,
    body: JSON.stringify({ message: "Upgrade failed" })
  };
});

export { upgrade as default };
