import { c as defineEventHandler, v as readMultipartFormData, j as createError, u as useRuntimeConfig, w as wpClient } from '../../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const upload = defineEventHandler(async (event) => {
  var _a;
  try {
    const formData = await readMultipartFormData(event);
    if (!formData) {
      throw createError({
        statusCode: 400,
        statusMessage: "Bad Request",
        message: "No form data found"
      });
    }
    const formDataMap = new Map(formData.map((item) => [item.name, item.data]));
    const chunk = formDataMap.get("chunk");
    const chunkIndex = formDataMap.get("chunkIndex");
    const totalChunks = formDataMap.get("totalChunks");
    const fileName = formDataMap.get("fileName");
    const fileSize = formDataMap.get("fileSize");
    if (!chunk || !chunkIndex || !totalChunks || !fileName || !fileSize) {
      throw createError({
        statusCode: 400,
        statusMessage: "Bad Request",
        message: "Missing required fields in form data"
      });
    }
    const chunkBlob = new Blob([chunk]);
    const chunkIndexInt = parseInt(chunkIndex.toString("utf-8"), 10);
    const totalChunksInt = parseInt(totalChunks.toString("utf-8"), 10);
    const fileNameStr = fileName.toString("utf-8");
    const fileSizeInt = parseInt(fileSize.toString("utf-8"), 10);
    const operations = JSON.stringify({
      query: `
        mutation($file: Upload!, $chunkIndex: Int!, $totalChunks: Int!, $name: String!, $fileSize: Int!) {
          fileUpload(input: {chunk: $file, chunkIndex: $chunkIndex, totalChunks: $totalChunks, name: $name, fileSize: $fileSize}) {
            mediaItem {
              mediaDetails {
                height
                width
              }
              databaseId
              altText
              caption
              sourceUrl
              mediaItemUrl
              mimeType
              sizes
              title
            }
          }
        }
      `,
      variables: {
        file: null,
        chunkIndex: chunkIndexInt,
        totalChunks: totalChunksInt,
        name: fileNameStr,
        fileSize: fileSizeInt
      }
    });
    const map = JSON.stringify({
      "0": ["variables.file"]
    });
    const newFormData = new FormData();
    newFormData.append("operations", operations);
    newFormData.append("map", map);
    newFormData.append("0", chunkBlob);
    const config = useRuntimeConfig();
    const opt = {
      method: "POST",
      headers: {
        "host": event.context.host,
        "X-Fe-Route": event.context.host,
        "X-Fe-Ip": event.context.ip
      },
      body: newFormData
    };
    const authorizationHeader = event.context.authToken ? `${event.context.authToken}` : null;
    if (authorizationHeader) {
      opt.headers.authorization = authorizationHeader;
    }
    const res = await wpClient(config.private.apiBase, opt);
    return res;
  } catch (error) {
    const msg = ((_a = error.message) == null ? void 0 : _a.replace(/"http:\/\/[^"]+":\s*/g, "")) || "Unknown error";
    throw createError({
      statusCode: 500,
      statusMessage: "Internal Server Error",
      message: "Chunk upload failed: " + msg
    });
  }
});

export { upload as default };
